/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.annotations.Direct;
import com.kenai.jaffl.annotations.In;
import com.kenai.jaffl.annotations.NulTerminate;
import com.kenai.jaffl.annotations.Out;
import com.kenai.jaffl.annotations.Pinned;
import com.kenai.jaffl.annotations.Transient;
import java.lang.annotation.Annotation;

public final class ParameterFlags {
    public static final int OUT = 1;
    public static final int IN = 2;
    public static final int PINNED = 4;
    public static final int NULTERMINATE = 8;
    public static final int TRANSIENT = 16;
    public static final int DIRECT = 32;

    private ParameterFlags() {
    }

    public static final int parse(Annotation[] annotationArray) {
        int n = 0;
        for (Annotation annotation : annotationArray) {
            n |= annotation instanceof Out ? 1 : 0;
            n |= annotation instanceof In ? 2 : 0;
            n |= annotation instanceof Transient ? 16 : 0;
            n |= annotation instanceof Direct ? 32 : 0;
            n |= annotation instanceof Pinned ? 4 : 0;
            n |= annotation instanceof NulTerminate ? 8 : 0;
        }
        return n;
    }

    public static final boolean isFlag(Annotation annotation) {
        return annotation instanceof Pinned || annotation instanceof Transient || annotation instanceof Direct || annotation instanceof NulTerminate || annotation instanceof Out || annotation instanceof In;
    }

    public static final boolean isPinned(int n) {
        return (n & 4) != 0;
    }

    public static final boolean isTransient(int n) {
        return (n & 0x10) != 0;
    }

    public static final boolean isDirect(int n) {
        return (n & 0x20) != 0;
    }

    public static final boolean isNulTerminate(int n) {
        return (n & 8) != 0;
    }

    public static final boolean isOut(int n) {
        return (n & 3) != 2;
    }

    public static final boolean isIn(int n) {
        return (n & 3) != 1;
    }
}

